/************************************************************************
 * NAME:	fs-cmp.c
 *
 * DESCR:	Implements the CPM file system on top of the floppy struct.
 *
 *
 * NOTES:	
 ************************************************************************/
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include "getopt.h"

#include "standard.h"
#include "floppy.h"
#include "fs-hcpm.h"
#include "fs-utility.h"


/************************************************************************
 * NAME:	fs_hcpm_init() and fs_hcpm_cleanup()
 *
 * DESCR:	Initializes/cleans-up the cpm file system structures.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_hcpm_init(struct floppy *floppy, struct fs_hcpm *fs)
{
    int	ok;
    extern int floppy_read_sector(struct floppy *, int, int, int, char *);
    extern int floppy_write_sector(struct floppy *, int, int, int, char *);

    fs->floppy = floppy;

    if (!cpm_init(&fs->cpmfs, floppy, floppy_read_sector, floppy_write_sector)) {
	return(FALSE);
    }

    return(cpm_settings(&fs->cpmfs,
			1024,		/* size of CPM block	*/
			floppy->tracks,	/* number of tracks	*/
			64,		/* maxdir entry		*/
			256,		/* length of sector	*/
			floppy->sectors,/* sectors per track	*/
			4,		/* sector skew		*/
			3,		/* number of boot tracks*/
			0,		/* phy sect starts at 0	*/
			5));		/* up to five open files*/
}

int
fs_hcpm_cleanup(struct fs_hcpm *fs)
{
    return(fs_cpm_cleanup(fs));
}

/************************************************************************
 * NAME:	fs_hcpm_report()
 *
 * DESCR:	Generates a report on the filesystem structure.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_hcpm_report(struct fs_hcpm *fs, int verbosity)
{
    return(fs_cpm_report(fs,verbosity));
}

/************************************************************************
 * NAME:	fs_hcpm_add()
 *
 * DESCR:	Adds the referenced file to the CPM image.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_hcpm_add(struct fs_hcpm *fs, char *name, int fd)
{
    return(fs_cpm_add(fs,name,fd));
}

/************************************************************************
 * NAME:	fs_hcpm_del()
 *
 * DESCR:	Deletes the named file from the filesystem.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_hcpm_del(struct fs_hcpm *fs, char *name)
{
    return(fs_cpm_del(fs,name));
}

/************************************************************************
 * NAME:	fs_hcpm_extract()
 *
 * DESCR:	Extracts the named file from the filesystem, sending it
 *		out on the given fd.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_hcpm_extract(struct fs_hcpm *fs, char *name, int fd)
{
    return(fs_hcpm_extract(fs,name,fd));
}

/************************************************************************
 * NAME:	fs_hcpm_description()
 *
 * DESCR:	Returns the description of this type of file system.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
char *
fs_hcpm_description(void)
{
    return("H8/H89 CP/M");
}


/************************************************************************
 * NAME:	fs_hcpm_compress()
 *
 * DESCR:
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:
 ************************************************************************/
int
fs_hcpm_compress(struct fs_hcpm *fs)
{
    return(fs_cpm_compress(fs));
}
